
import Link from 'next/link';
import { Button } from '@/components/ui/button';
import {
  Card,
  CardContent,
  CardDescription,
  CardHeader,
  CardTitle,
} from '@/components/ui/card';
import { ArrowLeft } from 'lucide-react';

export default function TermsOfUsePage() {
  return (
    <div className="max-w-4xl mx-auto p-4 md:p-6 bg-background text-foreground min-h-screen">
      <div className="flex items-center gap-4 mb-6">
        <Link href="/">
          <Button variant="outline" size="icon">
            <ArrowLeft className="h-4 w-4" />
          </Button>
        </Link>
        <h1 className="text-3xl font-bold">Termos de Uso</h1>
      </div>

      <Card>
        <CardHeader>
          <CardTitle>Termos e Condições de Uso</CardTitle>
          <CardDescription>Última atualização: Outubro de 2023</CardDescription>
        </CardHeader>
        <CardContent className="space-y-4">
          <p>
            Bem-vindo ao nosso cardápio digital. Ao utilizar nossos serviços, você concorda com os seguintes termos e condições.
          </p>

          <h3 className="font-semibold text-lg">1. Aceitação dos Termos</h3>
          <p>
            Ao acessar e usar este serviço, você aceita e concorda em estar vinculado pelos termos e disposições deste acordo.
          </p>

          <h3 className="font-semibold text-lg">2. Realização de Pedidos</h3>
          <p>
            Os pedidos realizados através do nosso cardápio digital são enviados diretamente ao nosso sistema via WhatsApp. Certifique-se de que todas as informações fornecidas, como itens, quantidades e endereço, estejam corretas antes de finalizar o pedido.
          </p>

           <h3 className="font-semibold text-lg">3. Pagamento</h3>
          <p>
            As formas de pagamento aceitas são aquelas descritas no momento da finalização do pedido (checkout). O pagamento é processado no momento da entrega ou conforme as instruções fornecidas.
          </p>

          <h3 className="font-semibold text-lg">4. Modificações nos Termos</h3>
          <p>
            Reservamo-nos o direito de modificar estes termos a qualquer momento. Todas as modificações serão publicadas nesta página. O uso continuado do serviço após quaisquer alterações constituirá sua aceitação dos novos termos.
          </p>
           <h3 className="font-semibold text-lg">5. Contato</h3>
          <p>
            Se você tiver alguma dúvida sobre estes Termos, entre em contato conosco através dos canais de atendimento informados no cardápio.
          </p>
        </CardContent>
      </Card>
    </div>
  );
}
